/*
 * Himax_ic_core.c
 *
 *      Author: 903621
 */
#include "himax_platform.h"
#include "himax_touch_driver.h"

int himax_init_power_saving_level(himax_dev_t *himax)
{
    uint8_t write_addr[4];
    uint8_t write_data[4];

    write_addr[0] = 0xA0;
    write_addr[1] = 0x00;
    write_addr[2] = 0x00;
    write_addr[3] = 0x90;

    write_data[0] = 0x00;
    write_data[1] = 0x00;
    write_data[2] = 0x00;
    write_data[3] = 0x00;

    if(himax_register_write(himax->i2c_fd, write_addr, write_data)== EIO){
        mtouch_error(himax->log_name, "setting fail\n");
        error_memory("Himax_Touch: setting fail\n");
        return -1;
    }
    return 0;
}

#if 0
static bool himax_mcu_wait_wip(himax_dev_t *himax, int Timing) /*Work In Process*/
{
    uint8_t tmp_data[4];
    uint8_t tmp_addr[4];
    int retry_cnt = 0;
    /*SPI Format*/
    tmp_addr[0] = 0x10;
    tmp_addr[1] = 0x00;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x80;

    tmp_data[0] = 0x80;
    tmp_data[1] = 0x07;
    tmp_data[2] = 0x02;
    tmp_data[3] = 0x00;

    himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
    /*SPI Format*/

    tmp_data[0] = 0x01;

    do {
        /*SPI Transfer Control*/
        tmp_addr[0] = 0x20;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;

        tmp_data[0] = 0x03;
        tmp_data[1] = 0x00;
        tmp_data[2] = 0x00;
        tmp_data[3] = 0x42;
        himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
        /*SPI Transfer Control*/

        /*SPI Command*/
        tmp_addr[0] = 0x24;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;

        tmp_data[0] = 0x05;
        tmp_data[1] = 0x00;
        tmp_data[2] = 0x00;
        tmp_data[3] = 0x00;
        himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
        /*SPI Command*/

        tmp_data[0] = tmp_data[1] = tmp_data[2] = tmp_data[3] = 0xFF;
        tmp_addr[0] = 0x2C;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;
        himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);


        if ((tmp_data[0] & 0x01) == 0x00)
            return true;

        retry_cnt++;

        if (tmp_data[0] != 0x00
        || tmp_data[1] != 0x00
        || tmp_data[2] != 0x00
        || tmp_data[3] != 0x00)
            mtouch_info(HIMAX_DEVNAME, "retry:%d, [0]=%d, [1]=%d,[2]=%d, [3]=%d\n",
            retry_cnt, tmp_data[0],
            tmp_data[1], tmp_data[2], tmp_data[3]);

        if (retry_cnt > 100) {
            mtouch_error(HIMAX_DEVNAME, "Wait WIP error!\n");
            return false;
        }

        if (usleep(Timing * 1000) != 0) {
            mtouch_error(HIMAX_DEVNAME, "Failed to execute sleep %d\n", errno);
        }
    } while ((tmp_data[0] & 0x01) == 0x01);

    return true;
}

static void himax_mcu_interface_on(himax_dev_t *himax)
{
    uint8_t tmp_data[4];
    uint8_t tmp_data2[4];
    uint8_t w_data[1];
    int cnt = 0;

    /* Read a dummy register to wake up I2C.*/

    if (himax_i2c_combined_writeread(himax->i2c_fd, 0x08, tmp_data, 4) != EOK) {
        mtouch_error(HIMAX_DEVNAME, "himax_i2c_combined_writeread i2c access fail!\n");
        return;
    }

    do {
        w_data[0] = 0x31;
        if (himax_i2c_write(himax->i2c_fd, 0x13, w_data, 1) != EOK) {
            mtouch_error(HIMAX_DEVNAME, "i2c access fail!\n");
            return;
        }
        w_data[0] = 0x10;
        if (himax_i2c_write(himax->i2c_fd, 0x0D, w_data, 1) != EOK) {
            mtouch_error(HIMAX_DEVNAME, "i2c access fail!\n");
            return;
        }

        /*Check cmd*/
        himax_i2c_combined_writeread(himax->i2c_fd, 0x13, tmp_data, 1);
        himax_i2c_combined_writeread(himax->i2c_fd, 0x0D, tmp_data2, 1);

        if (tmp_data[0] == 0x31 && tmp_data2[0] == 0x10)
            break;

        if (usleep(1000) != 0) {
            mtouch_error(HIMAX_DEVNAME, "Failed to execute 1ms sleep %d\n", errno);
        }
    } while (++cnt < 10);

    if (cnt > 0)
        mtouch_info(HIMAX_DEVNAME, "Polling burst mode: %d times\n", cnt);
}
#endif

int himax_mcu_read_FW_ver(himax_dev_t *himax)
{
    uint8_t tmp_data[12];
    uint8_t tmp_addr[4];
    uint8_t retry = 0;
    uint8_t reload_status = 0;

    mtouch_info(himax->log_name, "waiting for flash reload done\n");

    himax->ic_data = (himax_ic_data *)calloc(1, sizeof(*himax->ic_data));

    while (reload_status == 0) {
        tmp_addr[0] = 0xC0;
        tmp_addr[1] = 0x72;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x10;
        himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);

        mtouch_info(himax->log_name, "tmp_data[0]=0x%2.2X,tmp_data[1]=0x%2.2X,reload_status=%d\n",
        tmp_data[0], tmp_data[1], reload_status);

        if (tmp_data[1] == 0x72 && tmp_data[0] == 0xC0) {
            mtouch_info(himax->log_name, "Flash reload done\n");
            reload_status = 1;
            break;
        } else if (retry == 200) {
            mtouch_info(himax->log_name, "Flash reload fail !!!!!\n");
            return EIO;
        } else {
            retry++;
            if (usleep(10*1000) != 0) {
                 mtouch_error(himax->log_name, "Failed to execute 10ms sleep %d\n", errno);
                 error_memory("Himax_Touch: Failed to execute 10ms sleep %d\n", errno);
            }
            mtouch_info(himax->log_name, "Wait flash reload done for %d times\n", retry);
        }
    }

    /*** Register to read and determine if FW is for 6 or 10 finger ***/
    tmp_addr[0] = 0xF8;
    tmp_addr[1] = 0x70;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x10;
    himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);
    mtouch_info(himax->log_name, "HX_MAX_PT = %d, FW support reported max %d fingers\n", tmp_data[0], tmp_data[0]);
    /*** Register to read and determine if FW is for 6 or 10 finger ***/

    tmp_addr[0] = 0x04;
    tmp_addr[1] = 0x70;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x10;
    himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);
    himax->ic_data->vendor_panel_ver =  tmp_data[0];
    himax->ic_data->vendor_arch_ver = tmp_data[1] << 8 | tmp_data[2];
    mtouch_info(himax->log_name, "Panel Version : %X\n", himax->ic_data->vendor_panel_ver);
    mtouch_info(himax->log_name, "Architecture Version : %X\n", himax->ic_data->vendor_arch_ver);

    tmp_addr[0] = 0x84;
    tmp_addr[1] = 0x70;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x10;
    himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);
    himax->ic_data->vendor_touch_cfg_ver = tmp_data[2];
    mtouch_info(himax->log_name, "FW Touch Config. Version : %X\n", himax->ic_data->vendor_touch_cfg_ver);
    himax->ic_data->vendor_display_cfg_ver = tmp_data[3];
    mtouch_info(himax->log_name, "FW Display Config. Version : %X\n", himax->ic_data->vendor_display_cfg_ver);

    tmp_addr[0] = 0x00;
    tmp_addr[1] = 0x70;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x10;
    himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);
    himax->ic_data->vendor_cid_maj_ver = tmp_data[2];
    himax->ic_data->vendor_cid_min_ver = tmp_data[3];
    mtouch_info(himax->log_name, "CID : %X\n", (himax->ic_data->vendor_cid_maj_ver << 8
        | himax->ic_data->vendor_cid_min_ver));

    tmp_addr[0] = 0x08;
    tmp_addr[1] = 0x70;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x10;
    himax_register_read(himax->i2c_fd, tmp_addr, 12, tmp_data);
    memcpy(himax->ic_data->vendor_cus_info, tmp_data, 12);
    mtouch_info(himax->log_name, "Customer = %s\n", himax->ic_data->vendor_cus_info);

    tmp_addr[0] = 0x14;
    tmp_addr[1] = 0x70;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x10;
    himax_register_read(himax->i2c_fd, tmp_addr, 12, tmp_data);
    memcpy(himax->ic_data->vendor_proj_info, tmp_data, 12);
    mtouch_info(himax->log_name, "Project Name = %s\n", himax->ic_data->vendor_proj_info);

    tmp_addr[0] = 0x38;
    tmp_addr[1] = 0x70;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x10;
    himax_register_read(himax->i2c_fd, tmp_addr, 12, tmp_data);
    memcpy(himax->ic_data->vendor_config_date, tmp_data, 12);
    mtouch_info(himax->log_name, "Config. Date = %s\n", himax->ic_data->vendor_config_date);

    return EOK;

}

void himax_mcu_system_reset(himax_dev_t *himax)
{
    uint8_t tmp_addr[4] = {0};
    uint8_t tmp_data[4] = {0};

    tmp_addr[0] = 0x18;
    tmp_addr[1] = 0x00;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x90;

    tmp_data[0] = 0x55;
    tmp_data[1] = 0x00;
    tmp_data[2] = 0x00;
    tmp_data[3] = 0x00;
    himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
}

int hx83192_sense_off(himax_dev_t *himax)
{
    uint8_t cnt = 0;
    uint8_t tmp_addr[4] = {0};
    uint8_t tmp_data[4] = {0};
    uint8_t cMax = 7;
    uint8_t check = 0x87;
    uint8_t W_data[1];

    if ( usleep(280*1000) != 0) {
        mtouch_error(himax->log_name, "Failed to execute 280ms sleep %d\n", errno);
        error_memory("Himax_Touch: Failed to execute 280ms sleep %d\n", errno);
    }
    tmp_addr[0] = 0xA8;
    tmp_addr[1] = 0x00;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x90;
    himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);

    if (tmp_data[0] != 0x0C) {
        tmp_addr[0] = 0x5C;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x90;
        cnt = 0;
        do {
            tmp_data[0] = 0xA5;
            tmp_data[1] = 0x00;
            tmp_data[2] = 0x00;
            tmp_data[3] = 0x00;
            himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
            if (usleep(20*1000) != 0) {
                mtouch_error(himax->log_name, "Failed to execute 20ms sleep %d\n", errno);
                error_memory("Himax_Touch: Failed to execute 20ms sleep %d\n", errno);
            }
            himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);

            mtouch_info(himax->log_name, "Check 9000005C data[0]=%X\n", tmp_data[0]);
            if (cnt++ >= cMax)
                break;
        } while (tmp_data[0] != check);
    }

    cnt = 0;

    do {
        W_data[0] = 0x27;
        if (himax_i2c_write(himax->i2c_fd, 0x31, W_data, 1) != EOK) {
            mtouch_error(himax->log_name, "i2c access fail!\n");
            error_memory("Himax_Touch: i2c access fail!\n");
            return EIO;
        }
        W_data[0] = 0x95;
        if (himax_i2c_write(himax->i2c_fd, 0x32, W_data, 1) != EOK) {
            mtouch_error(himax->log_name, "i2c access fail!\n");
            error_memory("Himax_Touch: i2c access fail!\n");
            return EIO;
        }
        W_data[0] = 0x00;
        if (himax_i2c_write(himax->i2c_fd, 0x31, W_data, 1) != EOK) {
            mtouch_error(himax->log_name, "i2c access fail!\n");
            error_memory("Himax_Touch: i2c access fail!\n");
            return EIO;
        }
        if (usleep(100) != 0) {
            mtouch_error(himax->log_name, "Failed to execute 100Us sleep %d\n", errno);
            error_memory("Himax_Touch: Failed to execute 100Us sleep %d\n", errno);
        }
        W_data[0] = 0x27;
        if (himax_i2c_write(himax->i2c_fd, 0x31, W_data, 1) != EOK) {
            mtouch_error(himax->log_name, "i2c access fail!\n");
            error_memory("Himax_Touch: i2c access fail!\n");
            return EIO;
        }
        W_data[0] = 0x95;
        if (himax_i2c_write(himax->i2c_fd, 0x32, W_data, 1) != EOK) {
            mtouch_error(himax->log_name, "i2c access fail!\n");
            return EIO;
        }

        tmp_addr[0] = 0xA8;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x90;
        himax_register_read(himax->i2c_fd, tmp_addr, 4, tmp_data);
        mtouch_info(himax->log_name, "Check enter_save_mode data[0]=%X\n", tmp_data[0]);

        if (tmp_data[0] == 0x0C) {
            return EOK;
        } else if (cnt == 6) {
            if (usleep(10000) != 0) {
               mtouch_error(himax->log_name, "Failed to execute 10ms sleep %d\n", errno);
               error_memory("Himax_Touch: Failed to execute 10ms sleep %d\n", errno);
            }
            himax_mcu_system_reset(himax);
        }

    } while (cnt++ < 15);

    return EOK;
}

#if 0
static bool himax_mcu_block_erase(himax_dev_t *himax, int start_addr, int length)
{
    uint32_t page_prog_start = 0;
    uint32_t block_size = 0x10000;
    uint8_t tmp_addr[4] = {0};
    uint8_t tmp_data[4] = {0};

    himax_mcu_interface_on(himax);

    himax_init_power_saving_level(himax);
    /*SPI Format*/
    tmp_addr[0] = 0x10;
    tmp_addr[1] = 0x00;
    tmp_addr[2] = 0x00;
    tmp_addr[3] = 0x80;

    tmp_data[0] = 0x80;
    tmp_data[1] = 0x07;
    tmp_data[2] = 0x02;
    tmp_data[3] = 0x00;

    himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
    /*SPI Format*/

    for (page_prog_start = start_addr;
    page_prog_start < start_addr + length;
    page_prog_start = page_prog_start + block_size) {

        /*Flash Write Enable*/
        tmp_addr[0] = 0x20;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;

        tmp_data[0] = 0x00;
        tmp_data[1] = 0x00;
        tmp_data[2] = 0x00;
        tmp_data[3] = 0x47;
        himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);

        tmp_addr[0] = 0x24;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;

        tmp_data[0] = 0x06;
        tmp_data[1] = 0x00;
        tmp_data[2] = 0x00;
        tmp_data[3] = 0x00;
        himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
        /*Flash Write Enable*/

        /*SPI Address*/
        tmp_data[3] = (page_prog_start >> 24) & 0xFF;
        tmp_data[2] = (page_prog_start >> 16) & 0xFF;
        tmp_data[1] = (page_prog_start >> 8) & 0xFF;
        tmp_data[0] = page_prog_start & 0xFF;

        tmp_addr[0] = 0x28;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;
        himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
        /*SPI Address*/

        /*SPI Control*/
        tmp_addr[0] = 0x20;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;

        tmp_data[0] = 0x00;
        tmp_data[1] = 0x00;
        tmp_data[2] = 0x00;
        tmp_data[3] = 0x67;
        himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
        /*SPI Control*/
        /*Block Erase*/
        tmp_addr[0] = 0x24;
        tmp_addr[1] = 0x00;
        tmp_addr[2] = 0x00;
        tmp_addr[3] = 0x80;

        tmp_data[0] = 0xD8;
        tmp_data[1] = 0x00;
        tmp_data[2] = 0x00;
        tmp_data[3] = 0x00;
        himax_register_write(himax->i2c_fd, tmp_addr, tmp_data);
        /*Block Erase*/
        if (usleep(100 * 1000) != 0) {
            mtouch_error(HIMAX_DEVNAME, "Failed to execute 500ms sleep %d\n", errno);
        }

        if (!himax_mcu_wait_wip(himax, 100)) {
            mtouch_error(HIMAX_DEVNAME, "Erase Fail\n");
            return false;
        }
    }

    mtouch_info(HIMAX_DEVNAME, "END\n");
    return true;
}
#endif
